/*
 * Decompiled with CFR 0.152.
 */
package hu.karsany.djwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.algorithms.Algorithm;
import com.fasterxml.jackson.databind.ObjectMapper;
import hu.karsany.djwt.DetachedJwtData;
import hu.karsany.djwt.keys.pk.RSAPublicKeyExtra;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class DetachedJwtSigner {
    private final RSAPublicKey rsaPublicKey;
    private final RSAPrivateKey rsaPrivateKey;

    public DetachedJwtSigner(RSAPublicKey rsaPublicKey, RSAPrivateKey rsaPrivateKey) {
        this.rsaPublicKey = rsaPublicKey;
        this.rsaPrivateKey = rsaPrivateKey;
    }

    public DetachedJwtData sign(String originalPayload) {
        Algorithm algo = Algorithm.RSA512((RSAPublicKey)this.rsaPublicKey, (RSAPrivateKey)this.rsaPrivateKey);
        String sign = JWT.create().withHeader(this.buildHeader()).withPayload(this.buildPayload(originalPayload)).sign(algo);
        String[] split = sign.split("\\.");
        String detachedToken = split[0] + ".." + split[2];
        byte[] payload = Base64.getDecoder().decode(split[1]);
        return new DetachedJwtData(payload, detachedToken);
    }

    private Map<String, Object> buildHeader() {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        ret.put("alg", "RS512");
        ret.put("typ", "JWT");
        ret.put("iat", LocalDateTime.now().atZone(ZoneId.systemDefault()).toEpochSecond());
        ret.put("jti", UUID.randomUUID().toString());
        ret.put("kid", new RSAPublicKeyExtra(this.rsaPublicKey).getKeyHash());
        return ret;
    }

    private Map<String, ?> buildPayload(String jsonString) {
        return (Map)new ObjectMapper().readValue(jsonString, HashMap.class);
    }
}

