/*
 * Decompiled with CFR 0.152.
 */
package hu.karsany.djwt;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import hu.karsany.djwt.keys.repo.PublicKeyRepository;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;

public class DetachedJwtVerifier {
    private final PublicKeyRepository publicKeyRepository;

    public DetachedJwtVerifier(PublicKeyRepository publicKeyRepository) {
        this.publicKeyRepository = publicKeyRepository;
    }

    public boolean verify(byte[] body, String jwtSignature) {
        String[] split = jwtSignature.split("\\.\\.");
        String jwt = split[0] + "." + new String(Base64.getUrlEncoder().encode(body)) + "." + split[1];
        DecodedJWT decoded = JWT.decode((String)jwt);
        RSAPublicKey rsaPublicKey = this.publicKeyRepository.findPublicKey(decoded.getKeyId());
        try {
            JWTVerifier verifier = JWT.require((Algorithm)Algorithm.RSA512((RSAKey)rsaPublicKey)).build();
            verifier.verify(decoded);
            return true;
        }
        catch (JWTVerificationException jwtVerificationException) {
            return false;
        }
    }
}

