/*
 * Decompiled with CFR 0.152.
 */
package hu.karsany.util.fileintegrity.db;

import hu.karsany.util.fileintegrity.db.IntegrityDatabase;
import hu.karsany.util.fileintegrity.db.exception.IntegrityDatabaseException;
import hu.karsany.util.fileintegrity.file.IntegrityCheckedFile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Properties;

public class PropertiesFileIntegrityDatabase
implements IntegrityDatabase {
    private final File propertyFile;
    private Properties properties;

    public PropertiesFileIntegrityDatabase(File propertyFile) {
        Objects.requireNonNull(propertyFile, "The provided properties file can not be null");
        this.propertyFile = propertyFile;
    }

    private void load() {
        try {
            if (this.properties == null) {
                this.properties = new Properties();
                if (this.propertyFile.exists()) {
                    this.properties.load(new FileInputStream(this.propertyFile));
                }
            }
        }
        catch (Exception e) {
            throw new IntegrityDatabaseException(e);
        }
    }

    private void flush() {
        try (FileOutputStream out = new FileOutputStream(this.propertyFile);){
            this.properties.store(out, "Refresh at " + LocalDateTime.now());
        }
        catch (Exception e) {
            throw new IntegrityDatabaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(File file) {
        if (Objects.isNull(file)) {
            return false;
        }
        File file2 = this.propertyFile;
        synchronized (file2) {
            this.load();
            return this.properties.containsKey(file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void save(IntegrityCheckedFile file) {
        Objects.requireNonNull(file, "The provided integrity checked file can not be null.");
        File file2 = this.propertyFile;
        synchronized (file2) {
            this.load();
            this.properties.put(file.file().getAbsolutePath(), file.hash());
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getHash(File file) {
        Objects.requireNonNull(file, "The provided file can not be null.");
        File file2 = this.propertyFile;
        synchronized (file2) {
            this.load();
            return this.properties.getProperty(file.getAbsolutePath());
        }
    }
}

