/*
 * Decompiled with CFR 0.152.
 */
package hu.karsany.util.fileintegrity.digest;

import hu.karsany.util.fileintegrity.digest.DigestStrategy;
import hu.karsany.util.fileintegrity.digest.exception.DigestException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;

public class SaltedSha256DigestStrategy
implements DigestStrategy {
    private final String salt;
    private final MessageDigest digest;

    public SaltedSha256DigestStrategy(String salt) {
        this.salt = salt;
        try {
            this.digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new DigestException(e);
        }
    }

    @Override
    public String hash(File file) {
        String string;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        try {
            byte[] buffer = new byte[8192];
            while (bis.read(buffer) > 0) {
                this.digest.update(buffer);
            }
            if (Objects.nonNull(this.salt) && !this.salt.trim().isEmpty()) {
                this.digest.update(this.salt.getBytes());
            }
            byte[] hash = this.digest.digest();
            string = Base64.getEncoder().encodeToString(hash);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bis.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new DigestException(e);
            }
        }
        bis.close();
        return string;
    }
}

