/*
 * Decompiled with CFR 0.152.
 */
package hu.zabu.dynquery.query.oracle.parser;

import hu.zabu.dynquery.builder.filter.DQFDateBetween;
import hu.zabu.dynquery.query.oracle.parser.SqlFilterParser;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DQFDateBetweenFilterParser
implements SqlFilterParser<DQFDateBetween> {
    @Override
    public String buildBind(DQFDateBetween filter) {
        return filter.getField() + " BETWEEN :" + filter.getField() + "_FROM AND :" + filter.getField() + "_TO";
    }

    @Override
    public Map<String, Object> buildBind(DQFDateBetween filter, Object value) {
        HashMap<String, Object> x = new HashMap<String, Object>();
        Interval<LocalDate> fromTo = this.parseFromTo(value);
        x.put(filter.getField() + "_FROM", fromTo.getFrom());
        x.put(filter.getField() + "_TO", fromTo.getTo());
        return x;
    }

    private Interval<LocalDate> parseFromTo(Object value) {
        Object[] dts = this.toArray(value);
        return new ArrayBackedOrderedLocalDateFromTo(dts);
    }

    private Object[] toArray(Object o) {
        if (o.getClass().isArray()) {
            return (Object[])o;
        }
        return ((List)o).toArray();
    }

    private class ArrayBackedOrderedLocalDateFromTo
    implements Interval<LocalDate> {
        private final OrderedLocalDateFromTo dt;

        public ArrayBackedOrderedLocalDateFromTo(Object[] dts) {
            this.dt = dts.length == 1 ? new OrderedLocalDateFromTo(LocalDate.parse((CharSequence)dts[0])) : new OrderedLocalDateFromTo(LocalDate.parse((CharSequence)dts[0]), LocalDate.parse((CharSequence)dts[1]));
        }

        @Override
        public LocalDate getFrom() {
            return this.dt.getFrom();
        }

        @Override
        public LocalDate getTo() {
            return this.dt.getTo();
        }
    }

    private class OrderedLocalDateFromTo
    implements Interval<LocalDate> {
        private final LocalDate from;
        private final LocalDate to;

        private OrderedLocalDateFromTo(LocalDate from, LocalDate to) {
            if (to == null) {
                this.from = from;
                this.to = to;
            } else {
                this.from = from.isBefore(to) ? from : to;
                this.to = from.isBefore(to) ? to : from;
            }
        }

        private OrderedLocalDateFromTo(LocalDate fixDate) {
            this.from = fixDate;
            this.to = fixDate;
        }

        @Override
        public LocalDate getFrom() {
            return this.from;
        }

        @Override
        public LocalDate getTo() {
            return this.to;
        }
    }

    private static interface Interval<T> {
        public T getFrom();

        public T getTo();
    }
}

