/*
 * Decompiled with CFR 0.152.
 */
package hu.zabu.dynquery.query.oracle;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NamedParameterStatement {
    private final PreparedStatement statement;
    private final Map<String, int[]> indexMap = new HashMap<String, int[]>();

    public NamedParameterStatement(Connection connection, String query) throws SQLException {
        String parsedQuery = NamedParameterStatement.parse(query, this.indexMap);
        this.statement = connection.prepareStatement(parsedQuery);
    }

    static final String parse(String query, Map<String, int[]> indexMap) {
        HashMap<String, List<Integer>> paramMap = new HashMap<String, List<Integer>>();
        int length = query.length();
        StringBuilder parsedQuery = new StringBuilder(length);
        int index = 1;
        for (int i = 0; i < length; ++i) {
            int c = query.charAt(i);
            if (c == 39 || c == 34) {
                int original = c;
                do {
                    parsedQuery.append((char)c);
                } while (++i < length && (c = query.charAt(i)) != original);
            } else if (c == 58 && i + 1 < length && Character.isJavaIdentifierStart(query.charAt(i + 1))) {
                String name = NamedParameterStatement.parseParameterName(query, i);
                c = 63;
                i += name.length();
                LinkedList<Integer> indexList = (LinkedList<Integer>)paramMap.get(name);
                if (indexList == null) {
                    indexList = new LinkedList<Integer>();
                    paramMap.put(name, indexList);
                }
                indexList.add(index);
                ++index;
            }
            parsedQuery.append((char)c);
        }
        NamedParameterStatement.toIntArrayMap(paramMap, indexMap);
        return parsedQuery.toString();
    }

    private static String parseParameterName(String query, int pos) {
        int j;
        for (j = pos + 2; j < query.length() && Character.isJavaIdentifierPart(query.charAt(j)); ++j) {
        }
        return query.substring(pos + 1, j);
    }

    private static void toIntArrayMap(Map<String, List<Integer>> inMap, Map<String, int[]> outMap) {
        for (Map.Entry<String, List<Integer>> entry : inMap.entrySet()) {
            List<Integer> list = entry.getValue();
            int[] indexes = new int[list.size()];
            int i = 0;
            for (Integer integer : list) {
                indexes[i++] = integer;
            }
            outMap.put(entry.getKey(), indexes);
        }
    }

    private int[] getIndexes(String name) {
        int[] indexes = this.indexMap.get(name);
        if (indexes == null) {
            throw new IllegalArgumentException("Parameter not found: " + name);
        }
        return indexes;
    }

    public void setObject(String name, Object value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setObject(indexes[i], value);
        }
    }

    public void setString(String name, String value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setString(indexes[i], value);
        }
    }

    public void setInt(String name, int value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setInt(indexes[i], value);
        }
    }

    public void setLong(String name, long value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setLong(indexes[i], value);
        }
    }

    public void setTimestamp(String name, Timestamp value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setTimestamp(indexes[i], value);
        }
    }

    public void setDate(String name, Date value) throws SQLException {
        int[] indexes = this.getIndexes(name);
        for (int i = 0; i < indexes.length; ++i) {
            this.statement.setDate(indexes[i], value);
        }
    }

    public PreparedStatement getStatement() {
        return this.statement;
    }

    public boolean execute() throws SQLException {
        return this.statement.execute();
    }

    public ResultSet executeQuery() throws SQLException {
        return this.statement.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        return this.statement.executeUpdate();
    }

    public void close() throws SQLException {
        this.statement.close();
    }

    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }
}

