/*
 * Decompiled with CFR 0.152.
 */
package hu.zabu.dynquery.query.oracle.sqlbuilder;

import hu.zabu.dynquery.input.DQSort;
import hu.zabu.dynquery.query.oracle.sqlbuilder.Query;
import java.util.List;
import java.util.stream.Collectors;

public class OrderBy
implements Query {
    private final Query query;
    private final List<DQSort> sort;

    public OrderBy(Query query, List<DQSort> sort) {
        this.query = query;
        this.sort = sort;
    }

    @Override
    public String getQuery() {
        if (this.sort == null || this.sort.size() == 0) {
            return this.query.getQuery();
        }
        for (DQSort dqSort2 : this.sort) {
            if (this.query.getColumns().contains(dqSort2.getColumnName())) continue;
            throw new IllegalArgumentException("Illegal column: " + dqSort2.getColumnName());
        }
        String orderby = this.sort.stream().map(dqSort -> dqSort.getColumnName() + " " + (dqSort.getAscending() != false ? " ASC" : " DESC")).collect(Collectors.joining(","));
        return "SELECT * FROM (" + this.query.getQuery() + ") ORDER BY " + orderby;
    }

    @Override
    public List<String> getColumns() {
        return this.query.getColumns();
    }
}

