begin
  execute immediate 'drop table audit_stream_log';
  dbms_output.put_line('Table dropped: audit_stream_log');
exception
  when others then
    dbms_output.put_line('Table does not exists: audit_stream_log'); 
end;
/

begin
  execute immediate 'drop table audit_log';
  dbms_output.put_line('Table dropped: audit_log');
exception
  when others then
    dbms_output.put_line('Table does not exists: audit_log'); 
end;
/

begin
  execute immediate 'drop table event_log';
  dbms_output.put_line('Table dropped: event_log');
exception
  when others then
    dbms_output.put_line('Table does not exists: event_log'); 
end;
/

begin
  execute immediate 'create sequence event_log_seq start with 100000';
  dbms_output.put_line('Sequence created: event_log_seq');
exception
  when others then
    dbms_output.put_line('Sequence exists event_log_seq');
end;
/
begin
  execute immediate 'create sequence audit_log_seq start with 100000';
  dbms_output.put_line('Sequence created: audit_log_seq');
exception
  when others then
    dbms_output.put_line('Sequence exists audit_log_seq');
end;
/
begin
  execute immediate 'create sequence audit_stream_log_seq start with 100000';
  dbms_output.put_line('Sequence created: audit_stream_log_seq');
exception
  when others then
    dbms_output.put_line('Sequence exists audit_stream_log_seq');
end;
/


create table event_log (
  id                      number(20)   primary key,
  event_ts                timestamp(6) default systimestamp, -- timestamp
  event_level             varchar2(10), -- info, warn, error, crit
  event_type              number(20), -- message_id
  event_name              varchar(30), -- message_text
  event_text              varchar2(4000), -- user text
  call_stack              varchar2(4000),    
  error_stack             varchar2(4000),
  error_backtrace         varchar2(4000),  
  audit_id                number(20),
  audit_session_name      varchar2(100),
  audit_session_version   varchar2(100),
  event_caller_user       varchar2(100),
  event_os_user           varchar2(100),
  oracle_session_id       varchar2(100)
)
PARTITION BY RANGE (event_ts)
INTERVAL (NUMTODSINTERVAL(1,'day'))
(PARTITION p_first VALUES LESS THAN (date'2020-01-01'))
;

create table audit_log (
  audit_id 		          number(20) primary key,
  audit_session_ts	    timestamp(6) default systimestamp,
  audit_session_name    varchar2(100),
  audit_session_version varchar2(100),
  run_param             varchar2(4000),
  start_time      	  	timestamp(6),
  end_time        	  	timestamp(6)
)
PARTITION BY RANGE (audit_session_ts)
INTERVAL (NUMTODSINTERVAL(1,'day'))
(PARTITION p_first VALUES LESS THAN (date'2020-01-01'))
;

create table audit_stream_log (
  audit_stream_id		number(20) primary key,
  audit_id				  number(20) references audit_log(audit_id),
  stream_type		   	varchar2(10) check (stream_type in ('INPUT', 'OUTPUT')),
  owner					    varchar2(128),
  table_name			  varchar2(128),
  insert_ts			   	timestamp(6)
);

